#include "ee.h"



/***************************************************************************
 *
 * Stack definition for TriCore
 *
 **************************************************************************/
    #define STACK_1_SIZE 256 /* size = 256 bytes */

    EE_STACK_T EE_STACK_ATTRIB EE_tc_stack_1[EE_STACK_WLEN(STACK_1_SIZE)] EE_TC_FILL_STACK(EE_tc_stack_1);	/* Task 0 (TaskMaster) */

    const EE_UREG EE_std_thread_tos[EE_MAX_TASK+1] = {
        0U,	/* dummy */
        1U,	/* TaskMaster */
        0U,	/* TaskLET_Master */
        0U,	/* ISR_10 */
        0U,	/* ISR_5 */
        0U,	/* ISR_6 */
        0U,	/* ISR_4 */
        0U,	/* ISR_8 */
        0U,	/* ISR_7 */
        0U,	/* ISR_11 */
        0U 	/* ISR_9 */
    };

    struct EE_TC_TOS EE_tc_system_tos[EE_TC_SYSTEM_TOS_SIZE] = {
        {0, 0U},	/* Task   (dummy), Task 1 (TaskLET_Master), Task 2 (ISR_10), Task 3 (ISR_5), Task 4 (ISR_6), Task 5 (ISR_4), Task 6 (ISR_8), Task 7 (ISR_7), Task 8 (ISR_11), Task 9 (ISR_9) */
        {EE_STACK_INITP(EE_tc_stack_1), 0U} 	/* Task 0 (TaskMaster) */
    };

    EE_UREG EE_tc_active_tos = 0U; /* dummy */

    EE_tc_task_save_data EE_tc_tasks_RA[EE_MAX_TASK+1];



/***************************************************************************
 *
 * HW counter definition
 *
 **************************************************************************/
    const EE_oo_counter_hw_ROM_type EE_counter_hw_ROM[EE_COUNTER_HW_ROM_SIZE] = {
        {1000U}         /* CounterMaster */
    };



/***************************************************************************
 *
 * Kernel ( CPU 0 )
 *
 **************************************************************************/
    /* Definition of task's body */
    DeclareTask(TaskMaster);
    DeclareTask(TaskLET_Master);
    DeclareTask(ISR_10);
    DeclareTask(ISR_5);
    DeclareTask(ISR_6);
    DeclareTask(ISR_4);
    DeclareTask(ISR_8);
    DeclareTask(ISR_7);
    DeclareTask(ISR_11);
    DeclareTask(ISR_9);

    const EE_THREAD_PTR EE_hal_thread_body[EE_MAX_TASK] = {
        &EE_oo_thread_stub,		 /* thread TaskMaster */
        &EE_oo_thread_stub,		 /* thread TaskLET_Master */
        &EE_oo_thread_stub,		 /* thread ISR_10 */
        &EE_oo_thread_stub,		 /* thread ISR_5 */
        &EE_oo_thread_stub,		 /* thread ISR_6 */
        &EE_oo_thread_stub,		 /* thread ISR_4 */
        &EE_oo_thread_stub,		 /* thread ISR_8 */
        &EE_oo_thread_stub,		 /* thread ISR_7 */
        &EE_oo_thread_stub,		 /* thread ISR_11 */
        &EE_oo_thread_stub 		 /* thread ISR_9 */

    };

    EE_UINT32 EE_terminate_data[EE_MAX_TASK];

    /* ip of each thread body (ROM) */
    const EE_THREAD_PTR EE_terminate_real_th_body[EE_MAX_TASK] = {
        &FuncTaskMaster,
        &FuncTaskLET_Master,
        &FuncISR_10,
        &FuncISR_5,
        &FuncISR_6,
        &FuncISR_4,
        &FuncISR_8,
        &FuncISR_7,
        &FuncISR_11,
        &FuncISR_9
    };
    /* ready priority */
    const EE_TYPEPRIO EE_th_ready_prio[EE_MAX_TASK] = {
        0x1U,		 /* thread TaskMaster */
        0x200U,		 /* thread TaskLET_Master */
        0x100U,		 /* thread ISR_10 */
        0x80U,		 /* thread ISR_5 */
        0x40U,		 /* thread ISR_6 */
        0x20U,		 /* thread ISR_4 */
        0x10U,		 /* thread ISR_8 */
        0x8U,		 /* thread ISR_7 */
        0x4U,		 /* thread ISR_11 */
        0x2U 		 /* thread ISR_9 */
    };

    const EE_TYPEPRIO EE_th_dispatch_prio[EE_MAX_TASK] = {
        0x1U,		 /* thread TaskMaster */
        0x200U,		 /* thread TaskLET_Master */
        0x100U,		 /* thread ISR_10 */
        0x80U,		 /* thread ISR_5 */
        0x40U,		 /* thread ISR_6 */
        0x20U,		 /* thread ISR_4 */
        0x10U,		 /* thread ISR_8 */
        0x8U,		 /* thread ISR_7 */
        0x4U,		 /* thread ISR_11 */
        0x2U 		 /* thread ISR_9 */
    };

    /* thread status */
    EE_TYPESTATUS EE_th_status[EE_MAX_TASK] = {
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED
    };

    /* next thread */
    EE_TID EE_th_next[EE_MAX_TASK] = {
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL
    };

    /* The first stacked task */
    EE_TID EE_stkfirst = EE_NIL;

    /* system ceiling */
    EE_TYPEPRIO EE_sys_ceiling= 0x0000U;

    /* remaining nact: init= maximum pending activations of a Task */
    /* MUST BE 1 for BCC1 and ECC1 */
    EE_TYPENACT   EE_th_rnact[EE_MAX_TASK] =
        { 1U, 1U, 1U, 1U, 1U, 1U, 1U, 1U, 1U, 1U};

    /* First task in the ready queue (initvalue = EE_NIL) */
    EE_TID EE_rq_first  = EE_NIL;

    #ifndef __OO_NO_CHAINTASK__
        /* The next task to be activated after a ChainTask. initvalue=all EE_NIL */
        EE_TID EE_th_terminate_nextask[EE_MAX_TASK] = {
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL
        };
    #endif



/***************************************************************************
 *
 * Event handling
 *
 **************************************************************************/
    EE_TYPEEVENTMASK EE_th_event_active[EE_MAX_TASK] =
        { 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U};    /* thread event already active */

    EE_TYPEEVENTMASK EE_th_event_waitmask[EE_MAX_TASK] =
        { 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U};    /* thread wait mask */

    EE_TYPEBOOL EE_th_waswaiting[EE_MAX_TASK] =
        { EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE};

    const EE_TYPEBOOL EE_th_is_extended[EE_MAX_TASK] =
        { EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE};



/***************************************************************************
 *
 * Mutex
 *
 **************************************************************************/
    /*
     * This is the last mutex that the task has locked. This array
     *    contains one entry for each task. Initvalue= all -1. at runtime,
     *    it points to the first item in the EE_resource_stack data structure.
    */
    EE_UREG EE_th_resource_last[EE_MAX_TASK] =
        { (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1};

    /*
     * This array is used to store a list of resources locked by a
     *    task. there is one entry for each resource, initvalue = -1. the
     *    list of resources locked by a task is ended by -1.
    */
    EE_UREG EE_resource_stack[EE_MAX_RESOURCE] =
        { (EE_UREG) -1};

    /*
     * Only in extended status or when using ORTI with resources; for
     *    each resource, a flag is allocated to see if the resource is locked or
     *    not.  Note that this information cannot be easily knew from the previous
     *    two data structures. initvalue=0
    */
    EE_TYPEBOOL EE_resource_locked[EE_MAX_RESOURCE] =
        { EE_FALSE};

    const EE_TYPEPRIO EE_resource_ceiling[EE_MAX_RESOURCE]= {
        0x200U 		/* resource RES_SCHEDULER */
    };

    EE_TYPEPRIO EE_resource_oldceiling[EE_MAX_RESOURCE];



/***************************************************************************
 *
 * Counters
 *
 **************************************************************************/
    const EE_oo_counter_ROM_type EE_counter_ROM[EE_COUNTER_ROM_SIZE] = {
        {2147483647U, 1U, 1U}         /* CounterMaster */
    };

    EE_oo_counter_RAM_type       EE_counter_RAM[EE_MAX_COUNTER] = {
        {0U, (EE_TYPECOUNTEROBJECT)-1}
    };


/***************************************************************************
 *
 * Alarms
 *
 **************************************************************************/
    const EE_oo_alarm_ROM_type EE_alarm_ROM[EE_ALARM_ROM_SIZE] = {
        {0U},
        {1U},
        {2U},
        {3U},
        {4U},
        {5U},
        {6U},
        {7U},
        {8U},
        {9U},
        {10U},
        {11U},
        {12U},
        {13U},
        {14U},
        {15U},
        {16U},
        {17U},
        {18U},
        {19U},
        {20U},
        {21U}
    };


/***************************************************************************
 *
 * Counter Objects
 *
 **************************************************************************/
    const EE_oo_counter_object_ROM_type   EE_oo_counter_object_ROM[EE_COUNTER_OBJECTS_ROM_SIZE] = {

        {CounterMaster, AlarmISR_10, EE_ALARM },
        {CounterMaster, AlarmISR_5, EE_ALARM },
        {CounterMaster, AlarmISR_6, EE_ALARM },
        {CounterMaster, AlarmISR_4, EE_ALARM },
        {CounterMaster, AlarmISR_8, EE_ALARM },
        {CounterMaster, AlarmISR_7, EE_ALARM },
        {CounterMaster, AlarmISR_11, EE_ALARM },
        {CounterMaster, AlarmISR_9, EE_ALARM },
        {CounterMaster, AlarmTask_2ms, EE_ALARM },
        {CounterMaster, AlarmTask_5ms, EE_ALARM },
        {CounterMaster, AlarmTask_20ms, EE_ALARM },
        {CounterMaster, AlarmTask_50ms, EE_ALARM },
        {CounterMaster, AlarmTask_100ms, EE_ALARM },
        {CounterMaster, AlarmTask_200ms, EE_ALARM },
        {CounterMaster, AlarmTask_1000ms, EE_ALARM },
        {CounterMaster, AlarmISR_1, EE_ALARM },
        {CounterMaster, AlarmISR_2, EE_ALARM },
        {CounterMaster, AlarmISR_3, EE_ALARM },
        {CounterMaster, AlarmTask_10ms, EE_ALARM },
        {CounterMaster, AlarmLET_Master, EE_ALARM },
        {CounterMaster, AlarmLET_Slave1, EE_ALARM },
        {CounterMaster, AlarmLET_Slave2, EE_ALARM }
    };

    EE_oo_counter_object_RAM_type EE_oo_counter_object_RAM[EE_COUNTER_OBJECTS_ROM_SIZE];


/***************************************************************************
 *
 * Alarms and Scheduling Tables actions
 *
 **************************************************************************/
    const EE_oo_action_ROM_type   EE_oo_action_ROM[EE_ACTION_ROM_SIZE] = {

        {EE_ACTION_TASK    , ISR_10, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_5, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_6, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_4, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_8, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_7, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_11, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_9, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_2ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_5ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_20ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_50ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_100ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_200ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_1000ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_1, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_2, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , ISR_3, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , Task_10ms, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , TaskLET_Master, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , TaskLET_Slave1, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 },
        {EE_ACTION_TASK    , TaskLET_Slave2, 0U, (EE_VOID_CALLBACK)NULL, (EE_TYPECOUNTER)-1 }
    };



/***************************************************************************
 *
 * AppMode
 *
 **************************************************************************/
    EE_TYPEAPPMODE EE_ApplicationMode;


/***************************************************************************
 *
 * Auto Start (TASK)
 *
 **************************************************************************/
    static const EE_TID EE_oo_autostart_task_mode_OSDEFAULTAPPMODE[EE_OO_AUTOSTART_TASK_MODE_OSDEFAULTAPPMODE_SIZE] = 
        { TaskMaster };

    const struct EE_oo_autostart_task_type EE_oo_autostart_task_data[EE_MAX_APPMODE] = {
        { 1U, (const EE_TID (*const)[])&EE_oo_autostart_task_mode_OSDEFAULTAPPMODE}
    };

