#ifndef EECFG_H
#define EECFG_H


#define RTDRUID_CONFIGURATOR_NUMBER 1278



/***************************************************************************
 *
 * Common defines ( CPU 0 )
 *
 **************************************************************************/

    /* TASK definition */
    #define EE_MAX_TASK 10
    #define TaskMaster 0
    #define TaskLET_Master 1
    #define ISR_10 2
    #define ISR_5 3
    #define ISR_6 4
    #define ISR_4 5
    #define ISR_8 6
    #define ISR_7 7
    #define ISR_11 8
    #define ISR_9 9

    /* MUTEX definition */
    #define EE_MAX_RESOURCE 1U
    #define RES_SCHEDULER 0U

    /* ALARM definition */
    #define EE_MAX_ALARM 22U
    #define AlarmISR_10 0U
    #define AlarmISR_5 1U
    #define AlarmISR_6 2U
    #define AlarmISR_4 3U
    #define AlarmISR_8 4U
    #define AlarmISR_7 5U
    #define AlarmISR_11 6U
    #define AlarmISR_9 7U
    #define AlarmTask_2ms 8U
    #define AlarmTask_5ms 9U
    #define AlarmTask_20ms 10U
    #define AlarmTask_50ms 11U
    #define AlarmTask_100ms 12U
    #define AlarmTask_200ms 13U
    #define AlarmTask_1000ms 14U
    #define AlarmISR_1 15U
    #define AlarmISR_2 16U
    #define AlarmISR_3 17U
    #define AlarmTask_10ms 18U
    #define AlarmLET_Master 19U
    #define AlarmLET_Slave1 20U
    #define AlarmLET_Slave2 21U

    /* SCHEDULING TABLE definition */
    #define EE_MAX_SCHEDULETABLE 0U

    /* COUNTER OBJECTS definition */
    #define EE_MAX_COUNTER_OBJECTS (EE_MAX_ALARM + EE_MAX_SCHEDULETABLE)

    /* CPU CLOCK definition */
    #define EE_CPU_CLOCK      200000000U

    /* COUNTER definition */
    #define EE_MAX_COUNTER 1U
    #define CounterMaster 0U

    /* APPMODE definition */
    #define EE_MAX_APPMODE 1U

    /* CPUs */
    #define EE_MAX_CPU 3
    #define EE_CURRENTCPU 0

    /* Number of isr 2 */
    /* Remote procedure call requires an additional ISR2 */
    #define EE_MAX_ISR2   4
    #define EE_MAX_ISR_ID 3

#ifndef __DISABLE_EEOPT_DEFINES__


/***************************************************************************
 *
 * User options
 *
 **************************************************************************/
#define __ASSERT__
#define EE_ICACHE_ENABLED


/***************************************************************************
 *
 * Automatic options
 *
 **************************************************************************/
#define __RTD_CYGWIN__
#define __MSRP__
#define EE_TRIBOARD_TC2X5
#define EE_TRICORE__
#define EE_TC27X__
#define EE_GNU__
#define EE_START_CPU1
#define EE_START_CPU2
#define ENABLE_SYSTEM_TIMER
#define __OO_ORTI_LASTERROR__
#define __OO_ORTI_SERVICETRACE__
#define __OO_ORTI_PRIORITY__
#define __OO_ORTI_RES_LOCKER_TASK__
#define __OO_ORTI_RES_ISLOCKED__
#define __OO_ORTI_STACK__
#define __OO_ORTI_ALARMTIME__
#define __OO_ORTI_RUNNINGISR2__
#define EE_AS_RPC__
#define __OO_ECC1__
#define __OO_EXTENDED_STATUS__
#define __OO_HAS_ERRORHOOK__
#define __MULTI__
#define __OO_HAS_USERESSCHEDULER__
#define __OO_NO_EVENTS__
#define __OO_AUTOSTART_TASK__
#define __ALLOW_NESTED_IRQ__

#endif



/***************************************************************************
 *
 * Remote tasks
 *
 **************************************************************************/
    #define TaskLET_Slave1 ((EE_TID)10U + (EE_TID)EE_REMOTE_TID)
    #define Task_2ms ((EE_TID)11U + (EE_TID)EE_REMOTE_TID)
    #define Task_5ms ((EE_TID)12U + (EE_TID)EE_REMOTE_TID)
    #define Task_20ms ((EE_TID)13U + (EE_TID)EE_REMOTE_TID)
    #define Task_50ms ((EE_TID)14U + (EE_TID)EE_REMOTE_TID)
    #define Task_100ms ((EE_TID)15U + (EE_TID)EE_REMOTE_TID)
    #define Task_200ms ((EE_TID)16U + (EE_TID)EE_REMOTE_TID)
    #define Task_1000ms ((EE_TID)17U + (EE_TID)EE_REMOTE_TID)
    #define TaskLET_Slave2 ((EE_TID)18U + (EE_TID)EE_REMOTE_TID)
    #define ISR_1 ((EE_TID)19U + (EE_TID)EE_REMOTE_TID)
    #define ISR_2 ((EE_TID)20U + (EE_TID)EE_REMOTE_TID)
    #define ISR_3 ((EE_TID)21U + (EE_TID)EE_REMOTE_TID)
    #define Task_10ms ((EE_TID)22U + (EE_TID)EE_REMOTE_TID)


/***************************************************************************
 *
 * Remote alarms
 *
 **************************************************************************/


/***************************************************************************
 *
 * Remote counters
 *
 **************************************************************************/


/***************************************************************************
 *
 * Remote OsApplication
 *
 **************************************************************************/


/***************************************************************************
 *
 * Remote Schedule Tables
 *
 **************************************************************************/


/***************************************************************************
 *
 * Spin lock IDs
 *
 **************************************************************************/
    #define EE_MAX_SPINLOCK_USER 0

    #define EE_SPINLOCK_CORE0 2U	 /* master */
    #define EE_SPINLOCK_CORE1 1U	 /* slave1 */
    #define EE_SPINLOCK_CORE2 0U	 /* slave2 */
    #define EE_MAX_SPINLOCK 3
    #define EE_MAX_SPINLOCK_OS 3


    /* System stack size */
    #define EE_SYS_STACK_SIZE     4096



/***************************************************************************
 *
 * HW counter definition
 *
 **************************************************************************/
#define EE_MAX_COUNTER_HW 1
#define EE_SYSTEM_TIMER   CounterMaster
#define EE_SYSTEM_TIMER_DEVICE   EE_TC_STM_SR0

#define EE_TC_2_ISR EE_tc_system_timer_handler
#define EE_TC_2_ISR_PRI EE_ISR_PRI_2
#define EE_TC_2_ISR_CAT 2
#define EE_ISR2_ID_EE_tc_system_timer_handler 2

/* Max ISR priority */
#define EE_TC_MAX_ISR_ID     EE_ISR_PRI_2



/***************************************************************************
 *
 * Counter defines
 *
 **************************************************************************/
#define OSMAXALLOWEDVALUE_CounterMaster 2147483647U
#define OSTICKSPERBASE_CounterMaster    1U
#define OSMINCYCLE_CounterMaster        1U

#define OSMAXALLOWEDVALUE 2147483647U
#define OSTICKSPERBASE    1U
#define OSMINCYCLE        1U
#define OSTICKDURATION    1000000U



/***************************************************************************
 *
 * Vector size defines
 *
 **************************************************************************/
    #define EE_ACTION_ROM_SIZE 22
    #define EE_ALARM_ROM_SIZE 22
    #define EE_AS_RPC_ALARMS_SIZE 22
    #define EE_AS_RPC_COUNTERS_SIZE 1
    #define EE_AS_RPC_SERVICES_TABLE_SIZE 5
    #define EE_AS_RPC_TASKS_SIZE 23
    #define EE_COUNTER_HW_ROM_SIZE 1
    #define EE_COUNTER_OBJECTS_ROM_SIZE 22
    #define EE_COUNTER_ROM_SIZE 1
    #define EE_OO_AUTOSTART_TASK_MODE_OSDEFAULTAPPMODE_SIZE 1
    #define EE_TC_SYSTEM_TOS_SIZE 2


#endif

