#include "ee.h"



/***************************************************************************
 *
 * Stack definition for TriCore
 *
 **************************************************************************/


    const EE_UREG EE_std_thread_tos[EE_MAX_TASK+1] = {
        0U,	/* dummy */
        0U,	/* TaskLET_Slave1 */
        0U,	/* Task_2ms */
        0U,	/* Task_5ms */
        0U,	/* Task_20ms */
        0U,	/* Task_50ms */
        0U,	/* Task_100ms */
        0U,	/* Task_200ms */
        0U 	/* Task_1000ms */
    };

    struct EE_TC_TOS EE_tc_system_tos[EE_TC_SYSTEM_TOS_SIZE] = {
        {0, 0U} 	/* Task   (dummy), Task 0 (TaskLET_Slave1), Task 1 (Task_2ms), Task 2 (Task_5ms), Task 3 (Task_20ms), Task 4 (Task_50ms), Task 5 (Task_100ms), Task 6 (Task_200ms), Task 7 (Task_1000ms) */
    };

    EE_UREG EE_tc_active_tos = 0U; /* dummy */

    EE_tc_task_save_data EE_tc_tasks_RA[EE_MAX_TASK+1];



/***************************************************************************
 *
 * Kernel ( CPU 1 )
 *
 **************************************************************************/
    /* Definition of task's body */
    DeclareTask(TaskLET_Slave1);
    DeclareTask(Task_2ms);
    DeclareTask(Task_5ms);
    DeclareTask(Task_20ms);
    DeclareTask(Task_50ms);
    DeclareTask(Task_100ms);
    DeclareTask(Task_200ms);
    DeclareTask(Task_1000ms);

    const EE_THREAD_PTR EE_hal_thread_body[EE_MAX_TASK] = {
        &EE_oo_thread_stub,		 /* thread TaskLET_Slave1 */
        &EE_oo_thread_stub,		 /* thread Task_2ms */
        &EE_oo_thread_stub,		 /* thread Task_5ms */
        &EE_oo_thread_stub,		 /* thread Task_20ms */
        &EE_oo_thread_stub,		 /* thread Task_50ms */
        &EE_oo_thread_stub,		 /* thread Task_100ms */
        &EE_oo_thread_stub,		 /* thread Task_200ms */
        &EE_oo_thread_stub 		 /* thread Task_1000ms */

    };

    EE_UINT32 EE_terminate_data[EE_MAX_TASK];

    /* ip of each thread body (ROM) */
    const EE_THREAD_PTR EE_terminate_real_th_body[EE_MAX_TASK] = {
        &FuncTaskLET_Slave1,
        &FuncTask_2ms,
        &FuncTask_5ms,
        &FuncTask_20ms,
        &FuncTask_50ms,
        &FuncTask_100ms,
        &FuncTask_200ms,
        &FuncTask_1000ms
    };
    /* ready priority */
    const EE_TYPEPRIO EE_th_ready_prio[EE_MAX_TASK] = {
        0x80U,		 /* thread TaskLET_Slave1 */
        0x40U,		 /* thread Task_2ms */
        0x20U,		 /* thread Task_5ms */
        0x10U,		 /* thread Task_20ms */
        0x8U,		 /* thread Task_50ms */
        0x4U,		 /* thread Task_100ms */
        0x2U,		 /* thread Task_200ms */
        0x1U 		 /* thread Task_1000ms */
    };

    const EE_TYPEPRIO EE_th_dispatch_prio[EE_MAX_TASK] = {
        0x80U,		 /* thread TaskLET_Slave1 */
        0x40U,		 /* thread Task_2ms */
        0x20U,		 /* thread Task_5ms */
        0x10U,		 /* thread Task_20ms */
        0x8U,		 /* thread Task_50ms */
        0x4U,		 /* thread Task_100ms */
        0x2U,		 /* thread Task_200ms */
        0x1U 		 /* thread Task_1000ms */
    };

    /* thread status */
    EE_TYPESTATUS EE_th_status[EE_MAX_TASK] = {
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED,
        SUSPENDED
    };

    /* next thread */
    EE_TID EE_th_next[EE_MAX_TASK] = {
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL,
        EE_NIL
    };

    /* The first stacked task */
    EE_TID EE_stkfirst = EE_NIL;

    /* system ceiling */
    EE_TYPEPRIO EE_sys_ceiling= 0x0000U;

    /* remaining nact: init= maximum pending activations of a Task */
    /* MUST BE 1 for BCC1 and ECC1 */
    EE_TYPENACT   EE_th_rnact[EE_MAX_TASK] =
        { 1U, 1U, 1U, 1U, 1U, 1U, 1U, 1U};

    /* First task in the ready queue (initvalue = EE_NIL) */
    EE_TID EE_rq_first  = EE_NIL;

    #ifndef __OO_NO_CHAINTASK__
        /* The next task to be activated after a ChainTask. initvalue=all EE_NIL */
        EE_TID EE_th_terminate_nextask[EE_MAX_TASK] = {
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL,
            EE_NIL
        };
    #endif



/***************************************************************************
 *
 * Event handling
 *
 **************************************************************************/
    EE_TYPEEVENTMASK EE_th_event_active[EE_MAX_TASK] =
        { 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U};    /* thread event already active */

    EE_TYPEEVENTMASK EE_th_event_waitmask[EE_MAX_TASK] =
        { 0U, 0U, 0U, 0U, 0U, 0U, 0U, 0U};    /* thread wait mask */

    EE_TYPEBOOL EE_th_waswaiting[EE_MAX_TASK] =
        { EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE};

    const EE_TYPEBOOL EE_th_is_extended[EE_MAX_TASK] =
        { EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE, EE_FALSE};



/***************************************************************************
 *
 * Mutex
 *
 **************************************************************************/
    /*
     * This is the last mutex that the task has locked. This array
     *    contains one entry for each task. Initvalue= all -1. at runtime,
     *    it points to the first item in the EE_resource_stack data structure.
    */
    EE_UREG EE_th_resource_last[EE_MAX_TASK] =
        { (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1, (EE_UREG) -1};

    /*
     * This array is used to store a list of resources locked by a
     *    task. there is one entry for each resource, initvalue = -1. the
     *    list of resources locked by a task is ended by -1.
    */
    EE_UREG EE_resource_stack[EE_MAX_RESOURCE] =
        { (EE_UREG) -1};

    /*
     * Only in extended status or when using ORTI with resources; for
     *    each resource, a flag is allocated to see if the resource is locked or
     *    not.  Note that this information cannot be easily knew from the previous
     *    two data structures. initvalue=0
    */
    EE_TYPEBOOL EE_resource_locked[EE_MAX_RESOURCE] =
        { EE_FALSE};

    const EE_TYPEPRIO EE_resource_ceiling[EE_MAX_RESOURCE]= {
        0x80U 		/* resource RES_SCHEDULER */
    };

    EE_TYPEPRIO EE_resource_oldceiling[EE_MAX_RESOURCE];



/***************************************************************************
 *
 * AppMode
 *
 **************************************************************************/
    EE_TYPEAPPMODE EE_ApplicationMode;

