#ifndef EECFG_H
#define EECFG_H


#define RTDRUID_CONFIGURATOR_NUMBER 1278



/***************************************************************************
 *
 * Common defines ( CPU 1 )
 *
 **************************************************************************/

    /* TASK definition */
    #define EE_MAX_TASK 8
    #define TaskLET_Slave1 0
    #define Task_2ms 1
    #define Task_5ms 2
    #define Task_20ms 3
    #define Task_50ms 4
    #define Task_100ms 5
    #define Task_200ms 6
    #define Task_1000ms 7

    /* MUTEX definition */
    #define EE_MAX_RESOURCE 1U
    #define RES_SCHEDULER 0U

    /* ALARM definition */
    #define EE_MAX_ALARM 0U

    /* SCHEDULING TABLE definition */
    #define EE_MAX_SCHEDULETABLE 0U

    /* COUNTER OBJECTS definition */
    #define EE_MAX_COUNTER_OBJECTS (EE_MAX_ALARM + EE_MAX_SCHEDULETABLE)

    /* CPU CLOCK definition */
    #define EE_CPU_CLOCK      200000000U

    /* COUNTER definition */
    #define EE_MAX_COUNTER 0U

    /* APPMODE definition */
    #define EE_MAX_APPMODE 0U

    /* CPUs */
    #define EE_MAX_CPU 3
    #define EE_CURRENTCPU 1

    /* Number of isr 2 */
    /* Remote procedure call requires an additional ISR2 */
    #define EE_MAX_ISR2   1
    #define EE_MAX_ISR_ID 0

#ifndef __DISABLE_EEOPT_DEFINES__


/***************************************************************************
 *
 * User options
 *
 **************************************************************************/
#define __ASSERT__
#define EE_ICACHE_ENABLED


/***************************************************************************
 *
 * Automatic options
 *
 **************************************************************************/
#define __RTD_CYGWIN__
#define __MSRP__
#define EE_TRIBOARD_TC2X5
#define EE_TRICORE__
#define EE_TC27X__
#define EE_GNU__
#define __OO_ORTI_LASTERROR__
#define __OO_ORTI_SERVICETRACE__
#define __OO_ORTI_PRIORITY__
#define __OO_ORTI_RES_LOCKER_TASK__
#define __OO_ORTI_RES_ISLOCKED__
#define __OO_ORTI_STACK__
#define __OO_ORTI_ALARMTIME__
#define __OO_ORTI_RUNNINGISR2__
#define EE_AS_RPC__
#define __OO_ECC1__
#define __OO_EXTENDED_STATUS__
#define __OO_HAS_ERRORHOOK__
#define __MULTI__
#define __OO_HAS_USERESSCHEDULER__
#define __OO_NO_EVENTS__
#define __ALLOW_NESTED_IRQ__

#endif



/***************************************************************************
 *
 * Remote tasks
 *
 **************************************************************************/
    #define TaskMaster ((EE_TID)0U + (EE_TID)EE_REMOTE_TID)
    #define TaskLET_Master ((EE_TID)1U + (EE_TID)EE_REMOTE_TID)
    #define ISR_10 ((EE_TID)2U + (EE_TID)EE_REMOTE_TID)
    #define ISR_5 ((EE_TID)3U + (EE_TID)EE_REMOTE_TID)
    #define ISR_6 ((EE_TID)4U + (EE_TID)EE_REMOTE_TID)
    #define ISR_4 ((EE_TID)5U + (EE_TID)EE_REMOTE_TID)
    #define ISR_8 ((EE_TID)6U + (EE_TID)EE_REMOTE_TID)
    #define ISR_7 ((EE_TID)7U + (EE_TID)EE_REMOTE_TID)
    #define ISR_11 ((EE_TID)8U + (EE_TID)EE_REMOTE_TID)
    #define ISR_9 ((EE_TID)9U + (EE_TID)EE_REMOTE_TID)
    #define TaskLET_Slave2 ((EE_TID)18U + (EE_TID)EE_REMOTE_TID)
    #define ISR_1 ((EE_TID)19U + (EE_TID)EE_REMOTE_TID)
    #define ISR_2 ((EE_TID)20U + (EE_TID)EE_REMOTE_TID)
    #define ISR_3 ((EE_TID)21U + (EE_TID)EE_REMOTE_TID)
    #define Task_10ms ((EE_TID)22U + (EE_TID)EE_REMOTE_TID)


/***************************************************************************
 *
 * Remote alarms
 *
 **************************************************************************/
    #define AlarmISR_10 ((EE_TID)0U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_5 ((EE_TID)1U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_6 ((EE_TID)2U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_4 ((EE_TID)3U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_8 ((EE_TID)4U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_7 ((EE_TID)5U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_11 ((EE_TID)6U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_9 ((EE_TID)7U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_2ms ((EE_TID)8U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_5ms ((EE_TID)9U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_20ms ((EE_TID)10U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_50ms ((EE_TID)11U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_100ms ((EE_TID)12U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_200ms ((EE_TID)13U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_1000ms ((EE_TID)14U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_1 ((EE_TID)15U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_2 ((EE_TID)16U + (EE_TID)EE_REMOTE_TID)
    #define AlarmISR_3 ((EE_TID)17U + (EE_TID)EE_REMOTE_TID)
    #define AlarmTask_10ms ((EE_TID)18U + (EE_TID)EE_REMOTE_TID)
    #define AlarmLET_Master ((EE_TID)19U + (EE_TID)EE_REMOTE_TID)
    #define AlarmLET_Slave1 ((EE_TID)20U + (EE_TID)EE_REMOTE_TID)
    #define AlarmLET_Slave2 ((EE_TID)21U + (EE_TID)EE_REMOTE_TID)


/***************************************************************************
 *
 * Remote counters
 *
 **************************************************************************/
    #define CounterMaster ((EE_TID)0U + (EE_TID)EE_REMOTE_TID)


/***************************************************************************
 *
 * Remote OsApplication
 *
 **************************************************************************/


/***************************************************************************
 *
 * Remote Schedule Tables
 *
 **************************************************************************/


/***************************************************************************
 *
 * Spin lock IDs
 *
 **************************************************************************/
    #define EE_MAX_SPINLOCK_USER 0

    #define EE_SPINLOCK_CORE0 2U	 /* master */
    #define EE_SPINLOCK_CORE1 1U	 /* slave1 */
    #define EE_SPINLOCK_CORE2 0U	 /* slave2 */
    #define EE_MAX_SPINLOCK 3
    #define EE_MAX_SPINLOCK_OS 3


    /* System stack size */
    #define EE_SYS_STACK_SIZE     4096



/***************************************************************************
 *
 * Vector size defines
 *
 **************************************************************************/
    #define EE_AS_RPC_ALARMS_SIZE 22
    #define EE_AS_RPC_COUNTERS_SIZE 1
    #define EE_AS_RPC_SERVICES_TABLE_SIZE 5
    #define EE_AS_RPC_TASKS_SIZE 23
    #define EE_TC_SYSTEM_TOS_SIZE 1


#endif

