#include "shared.h"
#include "LET_turn_on_flags.h"
#include "LET_comm_read_cpu2.h"

#define INC_MOD(a, b) \
	a++; \
	if(a==(b)) a = 0;

/* TASK #14 */
EE_UINT8 read_flags_T14 = 0;
EE_UINT8 cnt_read_T14_T6 = 1;
#define MAX_CNT_read_T14_T6 2
EE_UINT8 cnt_read_T14_T17 = 1;
#define MAX_CNT_read_T14_T17 10

/* TASK #13 */
EE_UINT8 read_flags_T13 = 0;
EE_UINT8 cnt_read_T13_T17 = 1;
#define MAX_CNT_read_T13_T17 10
EE_UINT8 cnt_read_T13_T5 = 1;
#define MAX_CNT_read_T13_T5 5
EE_UINT8 cnt_read_T13_T1 = 1;
#define MAX_CNT_read_T13_T1 5

/* TASK #11 */
EE_UINT8 read_flags_T11 = 0;
EE_UINT8 cnt_read_T11_T17 = 1;
#define MAX_CNT_read_T11_T17 20

/* TASK #12 */
EE_UINT8 read_flags_T12 = 0;
EE_UINT8 cnt_read_T12_T17 = 1;
#define MAX_CNT_read_T12_T17 50

/* TASK #15 */
EE_UINT8 read_flags_T15 = 0;
EE_UINT8 cnt_read_T15_T17 = 1;
#define MAX_CNT_read_T15_T17 100
EE_UINT8 cnt_read_T15_T2 = 1;
#define MAX_CNT_read_T15_T2 100

/* TASK #10 */
EE_UINT8 read_flags_T10 = 0;
EE_UINT8 cnt_read_T10_T17 = 1;
#define MAX_CNT_read_T10_T17 200

/* TASK #16 */
EE_UINT8 read_flags_T16 = 0;
EE_UINT16 cnt_read_T16_T17 = 1;
#define MAX_CNT_read_T16_T17 1000



void do_cpu2_read_tick()
{
	/* TASK #14 */
	cnt_read_T14_T6--;
	if (cnt_read_T14_T6 == 0)
	{
		cnt_read_T14_T6 = MAX_CNT_read_T14_T6;
		read_flags_T14 |= TURN_ON_FLAG_1;
	}

	cnt_read_T14_T17--;
	if (cnt_read_T14_T17 == 0)
	{
		cnt_read_T14_T17 = MAX_CNT_read_T14_T17;
		read_flags_T14 |= TURN_ON_FLAG_2;
	}


	/* TASK #13 */
	cnt_read_T13_T17--;
	if (cnt_read_T13_T17 == 0)
	{
		cnt_read_T13_T17 = MAX_CNT_read_T13_T17;
		read_flags_T13 |= TURN_ON_FLAG_1;
	}

	cnt_read_T13_T5--;
	if (cnt_read_T13_T5 == 0)
	{
		cnt_read_T13_T5 = MAX_CNT_read_T13_T5;
		read_flags_T13 |= TURN_ON_FLAG_2;
	}

	cnt_read_T13_T1--;
	if (cnt_read_T13_T1 == 0)
	{
		cnt_read_T13_T1 = MAX_CNT_read_T13_T1;
		read_flags_T13 |= TURN_ON_FLAG_3;
	}


	/* TASK #11 */
	cnt_read_T11_T17--;
	if (cnt_read_T11_T17 == 0)
	{
		cnt_read_T11_T17 = MAX_CNT_read_T11_T17;
		read_flags_T11 |= TURN_ON_FLAG_1;
	}


	/* TASK #12 */
	cnt_read_T12_T17--;
	if (cnt_read_T12_T17 == 0)
	{
		cnt_read_T12_T17 = MAX_CNT_read_T12_T17;
		read_flags_T12 |= TURN_ON_FLAG_1;
	}


	/* TASK #15 */
	cnt_read_T15_T17--;
	if (cnt_read_T15_T17 == 0)
	{
		cnt_read_T15_T17 = MAX_CNT_read_T15_T17;
		read_flags_T15 |= TURN_ON_FLAG_1;
	}

	cnt_read_T15_T2--;
	if (cnt_read_T15_T2 == 0)
	{
		cnt_read_T15_T2 = MAX_CNT_read_T15_T2;
		read_flags_T15 |= TURN_ON_FLAG_2;
	}


	/* TASK #10 */
	cnt_read_T10_T17--;
	if (cnt_read_T10_T17 == 0)
	{
		cnt_read_T10_T17 = MAX_CNT_read_T10_T17;
		read_flags_T10 |= TURN_ON_FLAG_1;
	}


	/* TASK #16 */
	cnt_read_T16_T17--;
	if (cnt_read_T16_T17 == 0)
	{
		cnt_read_T16_T17 = MAX_CNT_read_T16_T17;
		read_flags_T16 |= TURN_ON_FLAG_1;
	}


}
void do_cpu2_read_comm()
{
	/* TASK #14 */
	if (read_flags_T14 & TURN_ON_FLAG_1)
		LET_do_read_T14_T6();
	if (read_flags_T14 & TURN_ON_FLAG_2)
		LET_do_read_T14_T17();
	read_flags_T14 = 0;

	/* TASK #13 */
	if (read_flags_T13 & TURN_ON_FLAG_1)
		LET_do_read_T13_T17();
	if (read_flags_T13 & TURN_ON_FLAG_2)
		LET_do_read_T13_T5();
	if (read_flags_T13 & TURN_ON_FLAG_3)
		LET_do_read_T13_T1();
	read_flags_T13 = 0;

	/* TASK #11 */
	if (read_flags_T11 & TURN_ON_FLAG_1)
		LET_do_read_T11_T17();
	read_flags_T11 = 0;

	/* TASK #12 */
	if (read_flags_T12 & TURN_ON_FLAG_1)
		LET_do_read_T12_T17();
	read_flags_T12 = 0;

	/* TASK #15 */
	if (read_flags_T15 & TURN_ON_FLAG_1)
		LET_do_read_T15_T17();
	if (read_flags_T15 & TURN_ON_FLAG_2)
		LET_do_read_T15_T2();
	read_flags_T15 = 0;

	/* TASK #10 */
	if (read_flags_T10 & TURN_ON_FLAG_1)
		LET_do_read_T10_T17();
	read_flags_T10 = 0;

	/* TASK #16 */
	if (read_flags_T16 & TURN_ON_FLAG_1)
		LET_do_read_T16_T17();
	read_flags_T16 = 0;

}
EE_UINT8 cpu2_has_to_read()
{
	if (read_flags_T14) return 0x1;
	if (read_flags_T13) return 0x1;
	if (read_flags_T11) return 0x1;
	if (read_flags_T12) return 0x1;
	if (read_flags_T15) return 0x1;
	if (read_flags_T10) return 0x1;
	if (read_flags_T16) return 0x1;
	return 0x0;
}
