#include "shared.h"
#include "LET_turn_on_flags.h"
#include "LET_comm_write_cpu0.h"

#define INC_MOD(a, b) \
	a++; \
	if(a==(b)) a = 0;

/* TASK #6 */
EE_UINT8 write_flags_T6 = 0;
EE_UINT8 cnt_write_T6_T14 = 1;
#define MAX_CNT_write_T6_T14 2

/* TASK #4 */
EE_UINT8 write_flags_T4 = 0;

/* TASK #3 */
EE_UINT8 write_flags_T3 = 0;
EE_UINT8 cnt_write_T3_T17 = 1;
#define MAX_CNT_write_T3_T17 10

/* TASK #5 */
EE_UINT8 write_flags_T5 = 0;
#define MAX_CNT_write_INDEX_T5_T13 2
EE_UINT8 cnt_phase_write_INDEX_T5_T13 = 0;
EE_UINT8 cnt_write_T5_T13 = 1;
EE_UINT8 MAX_CNT_write_T5_T13[2] = {4, 6};

/* TASK #1 */
EE_UINT8 write_flags_T1 = 0;
#define MAX_CNT_write_INDEX_T1_T13 2
EE_UINT8 cnt_phase_write_INDEX_T1_T13 = 0;
EE_UINT8 cnt_write_T1_T13 = 1;
EE_UINT8 MAX_CNT_write_T1_T13[2] = {4, 6};

/* TASK #2 */
EE_UINT8 write_flags_T2 = 0;
EE_UINT8 cnt_write_T2_T15 = 1;
#define MAX_CNT_write_T2_T15 100

/* TASK #7 */
EE_UINT8 write_flags_T7 = 0;

/* TASK #0 */
EE_UINT8 write_flags_T0 = 0;
#define MAX_CNT_write_INDEX_T0_T17 3
EE_UINT8 cnt_phase_write_INDEX_T0_T17 = 0;
EE_UINT8 cnt_write_T0_T17 = 1;
EE_UINT8 MAX_CNT_write_T0_T17[3] = {6, 12, 12};



void do_cpu0_write_tick()
{
	/* TASK #6 */
	cnt_write_T6_T14--;
	if (cnt_write_T6_T14 == 0)
	{
		cnt_write_T6_T14 = MAX_CNT_write_T6_T14;
		write_flags_T6 |= TURN_ON_FLAG_1;
	}


	/* TASK #4 */

	/* TASK #3 */
	cnt_write_T3_T17--;
	if (cnt_write_T3_T17 == 0)
	{
		cnt_write_T3_T17 = MAX_CNT_write_T3_T17;
		write_flags_T3 |= TURN_ON_FLAG_1;
	}


	/* TASK #5 */
	cnt_write_T5_T13--;
	if (cnt_write_T5_T13 == 0)
	{
		INC_MOD(cnt_phase_write_INDEX_T5_T13, MAX_CNT_write_INDEX_T5_T13);
		cnt_write_T5_T13 = MAX_CNT_write_T5_T13[cnt_phase_write_INDEX_T5_T13];
		write_flags_T5 |= TURN_ON_FLAG_1;
	}


	/* TASK #1 */
	cnt_write_T1_T13--;
	if (cnt_write_T1_T13 == 0)
	{
		INC_MOD(cnt_phase_write_INDEX_T1_T13, MAX_CNT_write_INDEX_T1_T13);
		cnt_write_T1_T13 = MAX_CNT_write_T1_T13[cnt_phase_write_INDEX_T1_T13];
		write_flags_T1 |= TURN_ON_FLAG_1;
	}


	/* TASK #2 */
	cnt_write_T2_T15--;
	if (cnt_write_T2_T15 == 0)
	{
		cnt_write_T2_T15 = MAX_CNT_write_T2_T15;
		write_flags_T2 |= TURN_ON_FLAG_1;
	}


	/* TASK #7 */

	/* TASK #0 */
	cnt_write_T0_T17--;
	if (cnt_write_T0_T17 == 0)
	{
		INC_MOD(cnt_phase_write_INDEX_T0_T17, MAX_CNT_write_INDEX_T0_T17);
		cnt_write_T0_T17 = MAX_CNT_write_T0_T17[cnt_phase_write_INDEX_T0_T17];
		write_flags_T0 |= TURN_ON_FLAG_1;
	}


}
void do_cpu0_write_comm()
{
	/* TASK #6 */
	if (write_flags_T6 & TURN_ON_FLAG_1)
		LET_do_write_T6_T14();
	write_flags_T6 = 0;

	/* TASK #4 */

	/* TASK #3 */
	if (write_flags_T3 & TURN_ON_FLAG_1)
		LET_do_write_T3_T17();
	write_flags_T3 = 0;

	/* TASK #5 */
	if (write_flags_T5 & TURN_ON_FLAG_1)
		LET_do_write_T5_T13();
	write_flags_T5 = 0;

	/* TASK #1 */
	if (write_flags_T1 & TURN_ON_FLAG_1)
		LET_do_write_T1_T13();
	write_flags_T1 = 0;

	/* TASK #2 */
	if (write_flags_T2 & TURN_ON_FLAG_1)
		LET_do_write_T2_T15();
	write_flags_T2 = 0;

	/* TASK #7 */

	/* TASK #0 */
	if (write_flags_T0 & TURN_ON_FLAG_1)
		LET_do_write_T0_T17();
	write_flags_T0 = 0;

}
