/* ###*B*###
 * ERIKA Enterprise - a tiny RTOS for small microcontrollers
 *
 * Copyright (C) 2002-2012  Evidence Srl
 *
 * This file is part of ERIKA Enterprise.
 *
 * ERIKA Enterprise is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation,
 * (with a special exception described below).
 *
 * Linking this code statically or dynamically with other modules is
 * making a combined work based on this code.  Thus, the terms and
 * conditions of the GNU General Public License cover the whole
 * combination.
 *
 * As a special exception, the copyright holders of this library give you
 * permission to link this code with independent modules to produce an
 * executable, regardless of the license terms of these independent
 * modules, and to copy and distribute the resulting executable under
 * terms of your choice, provided that you also meet, for each linked
 * independent module, the terms and conditions of the license of that
 * module.  An independent module is a module which is not derived from
 * or based on this library.  If you modify this code, you may extend
 * this exception to your version of the code, but you are not
 * obligated to do so.  If you do not wish to do so, delete this
 * exception statement from your version.
 *
 * ERIKA Enterprise is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2 for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with ERIKA Enterprise; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 * ###*E*### */

#include "shared.h"
#include "LET_labels_shared.h"
#include "LET_tick_write_cpu0.h"
#include "LET_tick_read_cpu0.h"

//----------------------------------------------------------------
#ifdef __USE_LET__
// Global pointers to spin variables
volatile EE_UINT8* EE_SHARED_UDATA LET_wait_WR_Master_ptr = NULL;
volatile EE_UINT8* EE_SHARED_UDATA LET_wait_WR_Slave1_ptr = NULL;
volatile EE_UINT8* EE_SHARED_UDATA LET_wait_RD_Slave1_ptr = NULL;
volatile EE_UINT8* EE_SHARED_UDATA LET_wait_WR_Slave2_ptr = NULL;
volatile EE_UINT8* EE_SHARED_UDATA LET_wait_RD_Slave2_ptr = NULL;

// Spin variables to be accessed
volatile EE_UINT8* LET_wait_RD_Slave1_loc_ptr;

// Spin variables
volatile EE_UINT8 LET_wait_WR_Master = 0;
#endif
//----------------------------------------------------------------


static EE_UINT32 error_counter;
volatile int a,b;

TASK(TaskMaster)
{
  volatile StatusType  status = 0;

#ifdef __USE_LET__
  status |= SetRelAlarm(AlarmLET_Master, 5, 1);
  status |= SetRelAlarm(AlarmLET_Slave1, 5, 1);
  status |= SetRelAlarm(AlarmLET_Slave2, 5, 10);
#endif

  status |= SetRelAlarm(AlarmISR_10, 5, 1);
  status |= SetRelAlarm(AlarmISR_5, 5, 1);
  status |= SetRelAlarm(AlarmISR_6, 5, 1);
  status |= SetRelAlarm(AlarmISR_4, 5, 2);
  status |= SetRelAlarm(AlarmISR_8, 5, 2);
  status |= SetRelAlarm(AlarmISR_7, 5, 5);
  status |= SetRelAlarm(AlarmISR_11, 5, 5);
  status |= SetRelAlarm(AlarmISR_9, 5, 6);

  status |= SetRelAlarm(AlarmTask_2ms, 5, 2);
  status |= SetRelAlarm(AlarmTask_5ms, 5, 5);
  status |= SetRelAlarm(AlarmTask_20ms, 5, 20);
  status |= SetRelAlarm(AlarmTask_50ms, 5, 50);
  status |= SetRelAlarm(AlarmTask_100ms, 5, 100);
  status |= SetRelAlarm(AlarmTask_200ms, 5, 200);
  status |= SetRelAlarm(AlarmTask_1000ms, 5, 1000);

  status |= SetRelAlarm(AlarmISR_1, 5, 10);
  status |= SetRelAlarm(AlarmISR_2, 5, 10);
  status |= SetRelAlarm(AlarmISR_3, 5, 10);
  status |= SetRelAlarm(AlarmTask_10ms, 5, 10);

  /* Cleanly terminate the Task */
  TerminateTask();
}


TASK(TaskLET_Master)
{
#ifdef __USE_LET__
	do_cpu0_write_tick();

	while(LET_wait_WR_Master == 0);
	LET_wait_WR_Master = 1;

	do_cpu0_write_comm();

	// Notify write completion unlocking the read phase of Slave1
	*LET_wait_RD_Slave1_loc_ptr = 0x1;
	asm("dsync");


	/* Cleanly terminate the Task */
	TerminateTask();
#endif
}


void ErrorHook( StatusType Error )
{
  //OSServiceIdType const service_id = OSErrorGetServiceId();
  CoreIdType      const core_id    = GetCoreID();

  if( core_id != OS_CORE_ID_MASTER )
  {
    /* This should never happened */
    EE_tc_debug();
  }

  ++error_counter;
}

/*
 * MAIN
 */
int main(void)
{
  StatusType status;

  /*P14_IOCR4.B.PC7    =   EE_TC2YX_OUTPUT_PUSH_PULL_GP;
  P14_OUT.B.P7 = (EE_UINT8)0x0;
  P14_OUT.B.P7 = (EE_UINT8)0x0;*/

#ifdef __USE_LET__
  LET_wait_WR_Master_ptr = &LET_wait_WR_Master;

  StartCore(OS_CORE_ID_1, &status);
  StartCore(OS_CORE_ID_2, &status);

  while(LET_wait_RD_Slave1_ptr == NULL);
  LET_wait_RD_Slave1_loc_ptr = LET_wait_RD_Slave1_ptr;
#endif

  StartOS(OSDEFAULTAPPMODE);
  return 0;
}
