/* ###*B*###
 * ERIKA Enterprise - a tiny RTOS for small microcontrollers
 *
 * Copyright (C) 2002-2011  Evidence Srl
 *
 * This file is part of ERIKA Enterprise.
 *
 * ERIKA Enterprise is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation,
 * (with a special exception described below).
 *
 * Linking this code statically or dynamically with other modules is
 * making a combined work based on this code.  Thus, the terms and
 * conditions of the GNU General Public License cover the whole
 * combination.
 *
 * As a special exception, the copyright holders of this library give you
 * permission to link this code with independent modules to produce an
 * executable, regardless of the license terms of these independent
 * modules, and to copy and distribute the resulting executable under
 * terms of your choice, provided that you also meet, for each linked
 * independent module, the terms and conditions of the license of that
 * module.  An independent module is a module which is not derived from
 * or based on this library.  If you modify this code, you may extend
 * this exception to your version of the code, but you are not
 * obligated to do so.  If you do not wish to do so, delete this
 * exception statement from your version.
 *
 * ERIKA Enterprise is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2 for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with ERIKA Enterprise; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 * ###*E*### */

#include "shared.h"
#include "LET_labels_shared.h"
#include "LET_tick_write_cpu2.h"
#include "LET_tick_read_cpu2.h"


#define LET_RATE_RATIO_SLAVE1_SLAVE2 10

//----------------------------------------------------------------
#ifdef __USE_LET__
// Spin variables
volatile EE_UINT8 LET_wait_RD_Slave1 = 0;

volatile EE_UINT8* LET_wait_WR_Master_loc_ptr;
volatile EE_UINT8* LET_wait_WR_Slave2_loc_ptr;
volatile EE_UINT8* LET_wait_RD_Slave2_loc_ptr;
#endif
//----------------------------------------------------------------


EE_UINT32 LET_Slave1_cnt = 1;

TASK(TaskLET_Slave1)
{
#ifdef __USE_LET__
  do_cpu2_write_tick();
  LET_Slave1_cnt--;

  do_cpu2_write_comm();

  do_cpu2_read_tick();

  if (LET_Slave1_cnt==0)
  {
	  LET_Slave1_cnt = LET_RATE_RATIO_SLAVE1_SLAVE2;

	  // Notify write completion to Slave2
	  *LET_wait_WR_Slave2_loc_ptr = 0x1;
	  asm("dsync");

	  // Wait for Master WR completion
	  while(LET_wait_RD_Slave1==0);
	  LET_wait_RD_Slave1 = 0;

	  do_cpu2_read_comm();

	  // Notify read completion
	  *LET_wait_RD_Slave2_loc_ptr = 0x1;
	  asm("dsync");
  }
  else
  {
	  // Notify write completion to Master
	  *LET_wait_WR_Master_loc_ptr = 0x1;
	  asm("dsync");

	  // Wait for Master WR completion
  	  while(LET_wait_RD_Slave1==0);
  	  LET_wait_RD_Slave1 = 0;

  	  do_cpu2_read_comm();
  }

  TerminateTask();
#endif
}

/*
 * MAIN TASK
 */
int main(void)
{

  /*P14_IOCR8.B.PC8    =   EE_TC2YX_OUTPUT_PUSH_PULL_GP;
  P14_OUT.B.P8 = (EE_UINT8)0x0;
  P14_OUT.B.P8 = (EE_UINT8)0x0;*/

#ifdef __USE_LET__
  // Populate global pointers
  LET_wait_RD_Slave1_ptr = &LET_wait_RD_Slave1;

  while(LET_wait_WR_Master_ptr==NULL);
  LET_wait_WR_Master_loc_ptr = LET_wait_WR_Master_ptr;
  while(LET_wait_WR_Slave2_ptr==NULL);
  LET_wait_WR_Slave2_loc_ptr = LET_wait_WR_Slave2_ptr;
  while(LET_wait_RD_Slave2_ptr==NULL);
  LET_wait_RD_Slave2_loc_ptr = LET_wait_RD_Slave2_ptr;
#endif

  StartOS(DONOTCARE);
  return 0;
}
